﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT LogManager : public nkCommon::MaybeSingletonClass<LogManager>
	{
		public :

			// Constructor
			LogManager () noexcept ;

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Log
			void log (nkMemory::StringView message, nkMemory::StringView className) ;

		private :

			// Functions
			// Constructor, destructor
			LogManager (bool isSingleton) noexcept ;
			LogManager (const LogManager&) = delete ;
			LogManager (LogManager&&) = delete ;

			// Operators
			LogManager& operator= (const LogManager&) = delete ;
			LogManager& operator= (LogManager&&) = delete ;

		private :

			// Attributes
			nkLog::Logger* _receiver ;

		private :

			friend class nkCommon::MaybeSingletonClass<LogManager> ;
			friend class System ;
	} ;
}